#!/usr/bin/env bash

[ $# -eq 0 ] && { echo "no arguments supplied" && exit 1 ; }

TARGET=$(realpath "$1")

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" &> /dev/null && pwd )"
cd "$SCRIPT_DIR"

for MATLAB in "R2015a/windows" "R2020a/linux"
do
    echo "# Build $(basename "$TARGET") with $MATLAB"
    rm -rf "$MATLAB/SOURCE"
    mkdir -p "$MATLAB/SOURCE"
    cp -r "$TARGET" "$MATLAB/SOURCE"
    make -C "$MATLAB" clean
    make -C "$MATLAB" "NAME=$(basename "$TARGET")"
    rm -rf "$MATLAB/SOURCE"
done
